#ifndef ZPL_SDK_API_H
#define ZPL_SDK_API_H

#include "sdk_common_api.h"

#define SDK_VERSION     "1,3,2,7"

SDK_API int CALL_STACK ZPL_StartFormat( void* handle );

SDK_API int CALL_STACK ZPL_EndFormat( void* handle );

SDK_API int CALL_STACK ZPL_ScalableFontText( void* handle, int xPos, int yPos, char fontName, int orientation, int fontWidth, int fontHeight, const TCHAR* text );

SDK_API int CALL_STACK ZPL_SetUserFontName( void* handle,  const TCHAR* text );

SDK_API int CALL_STACK ZPL_Text( void* handle, int xPos, int yPos, int fontNum, int orientation, int fontWidth, int fontHeight, const TCHAR* text );

SDK_API int CALL_STACK ZPL_Text_Block( void* handle, int xPos, int yPos, int fontNum, int orientation, int fontWidth, int fontHeight, int textblockWidth, int textblockHeight, const TCHAR* text );

SDK_API int CALL_STACK ZPL_FieldHexadecimalIndicator(void* handle);

SDK_API int CALL_STACK ZPL_AztecBarcode( void* handle, int xPos, int yPos, int orientation, int dpi, char extChannel, int eccLevel, char menuSymbol, int symbols, const TCHAR* text );

SDK_API int CALL_STACK ZPL_BarCode11( void* handle, int xPos, int yPos, int orientation,int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const TCHAR* text );

SDK_API int CALL_STACK ZPL_BarCode25( void* handle, char type, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const TCHAR* text );

SDK_API int CALL_STACK ZPL_BarCode39( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const TCHAR* text );

SDK_API int CALL_STACK ZPL_BarCode49( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char mode, const TCHAR* text );

SDK_API int CALL_STACK ZPL_PlanetCode( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const TCHAR* text );

SDK_API int CALL_STACK ZPL_Pdf417( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, int securityLevel, int columns, int rows, char truncate, const TCHAR* text );

SDK_API int CALL_STACK ZPL_CodeEan8( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const TCHAR* text );

SDK_API int CALL_STACK ZPL_UpceCode( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const TCHAR* text );

SDK_API int CALL_STACK ZPL_BarCode93( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const TCHAR* text );

SDK_API int CALL_STACK ZPL_BarCode128( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char checkDigit, char mode, const TCHAR* text );

SDK_API int CALL_STACK ZPL_CodeEan13( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const TCHAR* text );

SDK_API int CALL_STACK ZPL_MicroPdf417( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, int mode, const TCHAR* text );

SDK_API int CALL_STACK ZPL_AnsiCodebar( void* handle, int xPos, int yPos, int orientation,  int moduleWidth, int codeHeight, char line, char lineAboveCode, char startChar, char stopChar, const TCHAR* text );

SDK_API int CALL_STACK ZPL_LogMarsBarcode( void* handle, int xPos, int yPos, int orientation, int moduleWidth,  int codeHeight, char lineAboveCode, const TCHAR* text );

SDK_API int CALL_STACK ZPL_MsiBarcode( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAbovecode, char checkDigit, char insertCheck, const TCHAR* text );

SDK_API int CALL_STACK ZPL_PlesseyBarcode( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char checkDigit, const TCHAR* text );

SDK_API int CALL_STACK ZPL_QRCode( void* handle, int xPos, int yPos, int orientation, int model, int dpi, char eccLevel,char input, char charMode, const TCHAR* text );

SDK_API int CALL_STACK ZPL_UpcExtensions( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const TCHAR* text );

SDK_API int CALL_STACK ZPL_UpcaBarcode( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const TCHAR* text );

SDK_API int CALL_STACK ZPL_DataMatrixBarcode( void* handle, int xPos, int yPos, int orientation, int codeHeight, int level, int columns, int rows, int formatId, int aspectRatio, const TCHAR* text );

SDK_API int CALL_STACK ZPL_SetChangeFontEncoding(void* handle, int encodeType);

SDK_API int CALL_STACK ZPL_SetVietMode(void* handle, int vietmode);

SDK_API int CALL_STACK ZPL_SetVietFontEncoding(void* handle);

SDK_API int CALL_STACK ZPL_SetChangeCaret( void* handle, char charactor );

SDK_API int CALL_STACK ZPL_PostalBarcode( void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, int postalType, const TCHAR* text );

SDK_API int CALL_STACK ZPL_SetChangeDelimiter( void* handle, char charactor );

SDK_API int CALL_STACK ZPL_SetChangeDefaultFont( void* handle, char fontName, int width, int height);

SDK_API int CALL_STACK ZPL_SetChangeTilde( void* handle, char charactor );

SDK_API int CALL_STACK ZPL_GraphicBox( void* handle, int xPos, int yPos, int width, int height, int thickness, int rounding );

SDK_API int CALL_STACK ZPL_GraphicCircle( void* handle, int xPos, int yPos, int diameter, int thickness);

SDK_API int CALL_STACK ZPL_GraphicDiagonalLine( void* handle, int xPos, int yPos, int orientation, int width, int height, int thickness );

SDK_API int CALL_STACK ZPL_GraphicEllipse( void* handle, int xPos, int yPos, int width, int height, int thickness );

SDK_API int CALL_STACK ZPL_PrintImage( void* handle, int xPos, int yPos, const TCHAR* imgName );

SDK_API int CALL_STACK ZPL_GraphicSymbol( void* handle, int xPos, int yPos, int orientation, int width, int height, const TCHAR* symbol );

SDK_API int CALL_STACK ZPL_HostStatusReturn( void* handle, char* statuString );

SDK_API int CALL_STACK ZPL_SetMediaSensorCalibration( void* handle );

SDK_API int CALL_STACK ZPL_SetDiagnosticsMode( void* handle, int isEnable );

SDK_API int CALL_STACK ZPL_SetPowerOnReset( void* handle );

SDK_API int CALL_STACK ZPL_SetLabelHome( void* handle, int xPos, int yPos );

SDK_API int CALL_STACK ZPL_SetLabelLength( void* handle, int length);

SDK_API int CALL_STACK ZPL_SetLabelReversePrint( void* handle, char enable );

SDK_API int CALL_STACK ZPL_SetLabelShift( void* handle, int shift );

SDK_API int CALL_STACK ZPL_SetLabelTop( void* handle, int top );

SDK_API int CALL_STACK ZPL_SetPrintMode( void* handle, char mode, char prePeelSelect );

SDK_API int CALL_STACK ZPL_SetMediaTracking( void* handle, char mediaType, int offset );

SDK_API int CALL_STACK ZPL_SetMediaType( void* handle, char type );

SDK_API int CALL_STACK ZPL_SlewToHomePosition( void* handle, int type );

SDK_API int CALL_STACK ZPL_SetPrintingMirrorImage( void* handle, char enable );

SDK_API int CALL_STACK ZPL_SetPrintOrientation( void* handle, int orientation );

SDK_API int CALL_STACK ZPL_SetPrintQuantity( void* handle, int totalQuantity, int pauseAndCutValue, int replicatesOfEachSerialNumber, char overridePauseCount );

SDK_API int CALL_STACK ZPL_SetPrintRate( void* handle, int printSpeed, int slewSpeed, int backfeedSpeed );

SDK_API int CALL_STACK ZPL_SetPrintWidth( void* handle, int width );

SDK_API int CALL_STACK ZPL_SetSerialCommunications( void* handle, int baudRate, int wordLength, char parity, int stopBits, char protocolMode );

SDK_API int CALL_STACK ZPL_SetPrintDarkness( void* handle, int darkness );

SDK_API int CALL_STACK ZPL_SetSerializationField( void* handle, int xPos, int yPos, const TCHAR* mask, const TCHAR* increment, const TCHAR* text );

SDK_API int CALL_STACK ZPL_SetTearOffAdjustPosition( void* handle, int position );

SDK_API int CALL_STACK ZPL_PrintConfigurationLabel( void* handle );

SDK_API int CALL_STACK ZPL_GetPrinterIpAddress( void* handle, char* ipAddress );

SDK_API int CALL_STACK ZPL_GetPrinterStatus( void* handle, int* Status );

SDK_API int CALL_STACK ZPL_GetPrinterOdometer( void* handle, char* meters );

SDK_API int CALL_STACK ZPL_GetLabelLength( void* handle, char* length );

SDK_API int CALL_STACK ZPL_GetLabelWidth( void* handle, char* width );

SDK_API int CALL_STACK ZPL_GetPrinterSeriesNumber( void* handle, char* sn );

SDK_API int CALL_STACK ZPL_GetPrinterMacAddress( void* handle, char* macAddress );

SDK_API int CALL_STACK ZPL_GetPrinterName( void* handle, char* name );

SDK_API int CALL_STACK ZPL_GetPrinterFirmwareVersion( void* handle, char* version );

SDK_API int CALL_STACK ZPL_GetPrinterDpi( void* handle, char* dpi );

SDK_API int CALL_STACK ZPL_LearnLabel( void* handle);

SDK_API int CALL_STACK ZPL_SetReprintAfterError( void* handle, char* pEnable);

SDK_API int CALL_STACK ZPL_SetPrintIpAddress(void* handle, int mode, const TCHAR* ipaddress);

SDK_API int CALL_STACK ZPL_SetPrintSubnetMask( void* handle, const TCHAR* mask );

SDK_API int CALL_STACK ZPL_SetPrintDefaultGateway( void* handle, const TCHAR* gateway );

SDK_API int CALL_STACK ZPL_SetNetworkSetting( void* handle, char* network );

//SDK_API int CALL_STACK ZPL_PrintDirectoryLabel( void* handle, char* device, char* name, char* type );

SDK_API int CALL_STACK ZPL_SetWriteQuery( void* handle, int type );

SDK_API int CALL_STACK ZPL_RfidWrite( void* handle, char format,int begin,int size, char memoryBlock,const TCHAR* text );

SDK_API int CALL_STACK ZPL_RfidRead( void* handle, char format,int begin,int size, char memoryBlock,const TCHAR* headText, const TCHAR* tailText);

SDK_API int CALL_STACK ZPL_RfidCalibration( void* handle);

SDK_API int CALL_STACK ZPL_RfidReturnHostDatalog(void* handle);

SDK_API int CALL_STACK ZPL_RfidCorrectXpdnrPosition(void* handle, char* pStartStr, char* pEndStr, char* pStartPosition, char* pEndPosition, char model);

SDK_API int CALL_STACK ZPL_RfidDefineDataStruct(void* handle, int nTotalNum, int* pPartitionSize, int nPartitionLenth);

SDK_API int CALL_STACK ZPL_RfidRetryCount(void* handle, int nRetryCount);

SDK_API int CALL_STACK ZPL_RfidSetParameters(void* handle, int nTagNum, int nErrorAct);

SDK_API int CALL_STACK ZPL_RfidSetPowerLevel(void* handle, int nReadPower, int nWritePower, int nAntennaType);

SDK_API int CALL_STACK ZPL_RfidSetLockTagAndPassword(void* handle, char *password, int nMemoryBlock, char locktype);

SDK_API int CALL_STACK ZPL_RfidReadChipSerialization(void* handle);

SDK_API int CALL_STACK ZPL_RfidReadEmpty(void* handle);

SDK_API int CALL_STACK ZPL_Cutter(void* handle,int partialCutReserveDistance);

SDK_API int CALL_STACK ZPL_GetPrinterFonts( void* handle, char* fonts);
SDK_API int CALL_STACK ZPL_SetPrinterInstruction( void* handle, int type );
SDK_API int CALL_STACK ZPL_SetPrinterNetMode( void* handle, int mode );
SDK_API int CALL_STACK ZPL_SetPrinterNetSSID( void* handle, int mode,const TCHAR*  ssid );
SDK_API int CALL_STACK ZPL_SetPrinterNetPwd( void* handle, int mode,const TCHAR*  pwd );
SDK_API int CALL_STACK ZPL_SetPrinterNetPwdSwitch( void* handle, int mode);
SDK_API int CALL_STACK ZPL_SetPrinterNetDHCP( void* handle, int mode );
SDK_API int CALL_STACK ZPL_SetPrinterBluetoothSSID( void* handle, const TCHAR*  ssid );
SDK_API int CALL_STACK ZPL_SetPrinterBluetoothPIN( void* handle, const TCHAR*  pin );
SDK_API int CALL_STACK ZPL_SetPrinterSleepTime( void* handle, int time );
SDK_API int CALL_STACK ZPL_SetPrinterShutdownTime( void* handle, int time );

#ifndef LINUX
SDK_API int CALL_STACK ZPL_FirmwareUpgrade(void* handle,const TCHAR* cFileName,const TCHAR* model,const TCHAR* ioSettings);
SDK_API int CALL_STACK ZPL_FontDownload(void* handle,const TCHAR* cFileName,const TCHAR* model,const TCHAR* ioSettings);
SDK_API int CALL_STACK ZPL_VectorFontDownload(void* handle,const TCHAR* cFileName,const TCHAR* model,const TCHAR* ioSettings);
#endif

//=========================================

//add by wjz 20210527 ÷ɫ
SDK_API int CALL_STACK ZPL_SetInverse(void* handle);

SDK_API int CALL_STACK ZPL_Text_BlockEx(void* handle, int xPos, int yPos, int fontNum, int orientation,
	int fontWidth, int fontHeight,
	int textblockWidth, int maxline, int align, int hline_spacing, int vline_spacing,
	const TCHAR* text);

//add by wjz 20210923
SDK_API int CALL_STACK ZPL_PrintImageStream(void* handle, int xPos, int yPos, char* data, int len);

SDK_API int CALL_STACK GetSDKVersion(char* buffer, int len);

SDK_API int CALL_STACK ZPL_GetPrinterStatusEx(void* handle, unsigned char* buf, int buflen, int* readnum);

SDK_API int CALL_STACK ZPL_SetRFIDResultUploadingEnable(void* handle, int enable);

#endif
